package ru.yandex.msearch;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.msearch.util.Compress;
import ru.yandex.msearch.util.IOStater;
import ru.yandex.msearch.util.IOStats;
import ru.yandex.msearch.util.ImmutableIOStats;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.prefix.PrefixParser;

public class SearchHandlerBase {
    protected final DatabaseManager dbManager;
    //protected final Config config;
    protected final PatternMap<RequestInfo, IOStater> ioStaters;

    public SearchHandlerBase(
        final DatabaseManager dbManager,
        final Config config,
        final PatternMap<RequestInfo, IOStater> ioStaters)
    {
        this.dbManager = dbManager;
        //this.config = config;
        this.ioStaters = ioStaters;
    }

    public PrefixParser prefixParser(final DatabaseConfig config) {
        return config.prefixParser();
    }

    public Set<String> primaryKey(final Index index) {
        return index.config().primaryKey();
    }

    public void checkStoredField(final DatabaseConfig config, final String field)
        throws BadRequestException
    {
        SearchRequestBase.checkStoredField(config, field);
    }

    public QueryParser createParser(
        final DatabaseConfig config,
        final CgiParams params,
        final Analyzer analyzer)
        throws HttpException
    {
        return NewSearchRequest.createParser(config, params, analyzer);
    }

    protected IOStater ioStaterFor(final HttpContext context) {
        return ioStaters.get(
            (RequestInfo) context.getAttribute(HttpServer.REQUEST_INFO));
    }

    public static void accountStats(
        final IOStater ioStater,
        final Logger logger)
    {
        try {
            IOStats stats = Compress.stats();
            ioStater.accept(new ImmutableIOStats(stats));
            if (logger.isLoggable(Level.INFO)) {
                logger.info("IOStats: " + stats);
            }
        } catch (Exception ignore) {
            // TODO: WTF?
        }
    }
}

