package ru.yandex.msearch;

import java.util.Collection;
import java.util.Set;

import org.apache.lucene.search.Query;

import ru.yandex.msearch.collector.CollectingFieldToIndex;
import ru.yandex.msearch.collector.MergeFunc;
import ru.yandex.msearch.collector.aggregate.Aggregator;
import ru.yandex.msearch.collector.docprocessor.DocProcessor;
import ru.yandex.msearch.collector.group.GroupFunc;
import ru.yandex.msearch.collector.outergroup.OuterGroupFunction;
import ru.yandex.msearch.collector.postfilter.PostFilter;
import ru.yandex.msearch.collector.sort.SortFunc;

import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.search.YandexScorerFactory;
import ru.yandex.search.prefix.Prefix;

public interface SearchRequest {
    CollectingFieldToIndex fieldToIndex();

    RequestContext ctx();

    DatabaseConfig config();

    Index index();

    Collection<Prefix> prefixes();
    void setPrefixes(Collection<Prefix> prefixes);

    void setQueries(Collection<PrefixedQuery> queries);
    Collection<PrefixedQuery> queries();

    void setGetFields(Set<String> getFields);
    Set<String> getFields();

    void setOffset(int offset);
    int offset();

    void setLength(int length);
    int length();

    void memoryLimit(long limit);
    long memoryLimit();

    void setGroup(GroupFunc group);
    GroupFunc group();

    void setMergeFunc(MergeFunc mergeFunc);
    MergeFunc mergeFunc();

    void setSort(SortFunc sort);
    SortFunc sort();

    void setSortDirection(boolean direction);
    boolean sortDirection();

    void setSkipNulls(boolean skip);
    boolean skipNulls();

    void setOuterGroup(OuterGroupFunction outerGroup);
    OuterGroupFunction outerGroup();

    void setAggregator(Aggregator aggregator);
    Aggregator aggregator();

    void setDocProcessor(DocProcessor docProcessor);
    DocProcessor docProcessor();

    void setPostFilter(PostFilter postFilter);
    PostFilter postFilter();

    String forcedCollectorName();

    String pruningGroupField();

    boolean forcePruningGroupField();

    boolean debug();

    YandexScorerFactory scorerFactory();
    void setScorerFactory(YandexScorerFactory scorerFactory);

    boolean scoring();

    String userIdField();

    String userIdTerm();

    boolean reverseTraverse();

    boolean updatePrefixActivity();

    /**
     * Should we read fields marked as out fields for doc processor
     * Could be usefull if docprocessor has chance not to set field
     * @return
     */
    boolean dpReadOutFields();

    boolean syncSearcher();

    boolean earlyInterrupt();
}
