package ru.yandex.msearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.collector.CollectingFieldToIndex;
import ru.yandex.msearch.collector.MergeFunc;
import ru.yandex.msearch.collector.SortedCollector;
import ru.yandex.msearch.collector.aggregate.Aggregator;
import ru.yandex.msearch.collector.docprocessor.DocProcessor;
import ru.yandex.msearch.collector.docprocessor.NullDocProcessor;
import ru.yandex.msearch.collector.group.NullGroupFunc;
import ru.yandex.msearch.collector.group.GroupFunc;
import ru.yandex.msearch.collector.outergroup.OuterGroupFunction;
import ru.yandex.msearch.collector.postfilter.NullPostFilter;
import ru.yandex.msearch.collector.postfilter.PostFilter;
import ru.yandex.msearch.collector.sort.NullSortFunc;
import ru.yandex.msearch.collector.sort.SortFunc;

import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.search.NullScorerFactory;
import ru.yandex.search.YandexScorerFactory;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixParser;

public class SearchRequestBase implements SearchRequest {
    protected final CollectingFieldToIndex fieldToIndex =
        new CollectingFieldToIndex();
    protected Collection<PrefixedQuery> queries;
    protected Collection<Prefix> prefixes;
    protected final RequestContext ctx;
    protected final Index index;
    protected final DatabaseConfig config;

    protected Set<String> getFields;
    protected int offset = 0;
    protected int length = Integer.MAX_VALUE;
    protected long memoryLimit = Long.MAX_VALUE;
    protected GroupFunc group = NullGroupFunc.INSTANCE;
    protected MergeFunc mergeFunc;
    protected SortFunc sort = NullSortFunc.INSTANCE;
    protected boolean sortDirection = false; //desc
    protected boolean skipNulls = true;
    protected boolean debug = false;
    protected boolean forcePruningGroupField = false;
    protected OuterGroupFunction outerGroup = null;
    protected Aggregator aggregator = null;
    protected DocProcessor docProcessor = NullDocProcessor.INSTANCE;
    protected PostFilter postFilter = NullPostFilter.INSTANCE;
    protected String collectorName = null;
    protected String pruningGroupField = null;
    protected YandexScorerFactory scorerFactory;
    protected String userIdField = null;
    protected String userIdTerm = null;
    protected boolean reverseTraverse = true;
    protected boolean updatePrefixActivity = false;
    protected boolean docProcessorReadOutFields = false;
    protected boolean syncSearcher = true;
    protected boolean earlyInterrupt;

    protected SearchRequestBase(
        final RequestContext ctx,
        final Index index,
        final DatabaseConfig config)
    {
        this.ctx = ctx;
        this.index = index;
        this.config = config;
    }

    @Override
    public CollectingFieldToIndex fieldToIndex() {
        return fieldToIndex;
    }

    @Override
    public Index index() {
        return index;
    }

    public PrefixParser prefixParser() {
        return config.prefixParser();
    }

    public Set<String> primaryKey() {
        return config.primaryKey();
    }

    public void checkStoredField(final String field)
        throws BadRequestException
    {
        checkStoredField(config, field);
    }

    public static void checkStoredField(
        final DatabaseConfig config,
        final String field)
        throws BadRequestException
    {
        if (field.startsWith("#")) {
            return;
        }
        FieldConfig fieldConfig = config.fieldConfig(field);
        if (fieldConfig == null) {
            throw new BadRequestException("Unknown field: " + field);
        }
        if (!fieldConfig.store()) {
            throw new BadRequestException("Value for field: " + field
                + ", is not stored in index");
        }
    }

    @Override
    public RequestContext ctx() {
        return ctx;
    }

    @Override
    public DatabaseConfig config() {
        return config;
    }

    @Override
    public Collection<Prefix> prefixes() {
        return prefixes;
    }

    @Override
    public void setPrefixes(final Collection<Prefix> prefixes) {
        this.prefixes = prefixes;
    }

    @Override
    public void setQueries(final Collection<PrefixedQuery> queries) {
        this.queries = queries;
    }

    @Override
    public Collection<PrefixedQuery> queries() {
        return queries;
    }

    @Override
    public void setGetFields(final Set<String> getFields) {
        this.getFields = getFields;
    }

    @Override
    public Set<String> getFields() {
        return getFields;
    }

    @Override
    public void setOffset(final int offset) {
        this.offset = offset;
    }

    @Override
    public int offset() {
        return offset;
    }

    @Override
    public void setLength(final int length) {
        this.length = length;
    }

    @Override
    public int length() {
        return length;
    }

    @Override
    public void memoryLimit(final long memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    @Override
    public long memoryLimit() {
        return memoryLimit;
    }

    @Override
    public void setGroup(final GroupFunc group) {
        this.group = group;
    }

    @Override
    public GroupFunc group() {
        return group;
    }

    @Override
    public void setMergeFunc(final MergeFunc mergeFunc) {
        this.mergeFunc = mergeFunc;
    }

    @Override
    public MergeFunc mergeFunc() {
        return mergeFunc;
    }

    @Override
    public void setSort(final SortFunc sort) {
        this.sort = sort;
    }

    @Override
    public SortFunc sort() {
        return sort;
    }

    @Override
    public void setSortDirection(final boolean direction) {
        this.sortDirection = direction;
    }

    @Override
    public boolean sortDirection() {
        return sortDirection;
    }

    @Override
    public void setSkipNulls(final boolean skip) {
        this.skipNulls = skip;
    }

    @Override
    public boolean skipNulls() {
        return skipNulls;
    }

    @Override
    public void setOuterGroup(final OuterGroupFunction outerGroup) {
        this.outerGroup = outerGroup;
    }

    @Override
    public OuterGroupFunction outerGroup() {
        return outerGroup;
    }

    @Override
    public void setAggregator(final Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    @Override
    public Aggregator aggregator() {
        return aggregator;
    }

    @Override
    public void setDocProcessor(final DocProcessor docProcessor) {
        this.docProcessor = docProcessor;
    }

    @Override
    public DocProcessor docProcessor() {
        return docProcessor;
    }

    @Override
    public void setPostFilter(final PostFilter postFilter) {
        this.postFilter = postFilter;
    }

    @Override
    public PostFilter postFilter() {
        return postFilter;
    }

    @Override
    public String forcedCollectorName() {
        return collectorName;
    }

    @Override
    public String pruningGroupField() {
        return pruningGroupField;
    }

    @Override
    public boolean forcePruningGroupField() {
        return forcePruningGroupField;
    }

    @Override
    public boolean debug() {
        return debug;
    }

    @Override
    public void setScorerFactory(final YandexScorerFactory scorerFactory) {
        this.scorerFactory = scorerFactory;
    }

    @Override
    public YandexScorerFactory scorerFactory() {
        return scorerFactory;
    }

    @Override
    public boolean scoring() {
        return !(
            scorerFactory == null
            || scorerFactory instanceof NullScorerFactory);
    }

    @Override
    public String userIdField() {
        return userIdField;
    }

    @Override
    public String userIdTerm() {
        return userIdTerm;
    }

    @Override
    public boolean reverseTraverse() {
        return reverseTraverse;
    }

    @Override
    public boolean updatePrefixActivity() {
        return updatePrefixActivity;
    }

    @Override
    public boolean dpReadOutFields() {
        return docProcessorReadOutFields;
    }

    public SearchRequestBase dpReadOutFields(
        final boolean flag)
    {
        this.docProcessorReadOutFields = flag;
        return this;
    }

    @Override
    public boolean syncSearcher() {
        return syncSearcher;
    }

    @Override
    public boolean earlyInterrupt() {
        return earlyInterrupt;
    }
}
