package ru.yandex.msearch;

import java.io.IOException;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;

public class ShardSearcher extends Searcher
{
    private Shard parent;
    private Shard.CacheTracker tracker; //track core readers reopen

    private ShardSearcher() {
        super();
    }

    public ShardSearcher(
        final IndexSearcher s,
        final IndexReader r,
        final Shard parent,
        final Shard.CacheTracker tracker)
    {
        super(s, r);
        this.parent = parent;
        this.tracker = tracker;
    }

    @Override
    public void free() throws IOException {
        parent.freeSearcher(this);
    }

    @Override
    public void close() throws IOException {
        tracker.decRef();
        super.close();
    }

    public Shard.CacheTracker tracker() {
        return tracker;
    }
}
