package ru.yandex.msearch;

import java.text.ParseException;

import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixParser;

public class UnsharingPrefixParser implements PrefixParser {
    private final PrefixParser prefixParser;

    public UnsharingPrefixParser(final PrefixParser prefixParser) {
        this.prefixParser = prefixParser;
    }

    private static String unshare(final String value) {
        StringBuilder sb = new StringBuilder(value.length());
        sb.append(value);
        return new String(sb);
    }

    @Override
    public Prefix parse(final Object value) throws ParseException {
        if (value instanceof String) {
            return parse((String) value);
        } else {
            return prefixParser.parse(value);
        }
    }

    @Override
    public Prefix parse(final String value) throws ParseException {
        StringBuilder sb = new StringBuilder(value.length());
        sb.append(value);
        return prefixParser.parse(new String(sb));
    }
}

