package ru.yandex.msearch;

/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Map;

import java.util.logging.Logger;

import java.text.ParseException;

import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.search.json.fieldfunction.ConditionsAccessor;
import ru.yandex.search.json.fieldfunction.FieldFunction;
import ru.yandex.search.json.fieldfunction.FieldFunctionException;
import ru.yandex.search.json.fieldfunction.value.DefaultValue;
import ru.yandex.search.json.fieldfunction.value.FunctionValue;

import ru.yandex.search.prefix.Prefix;

public class UpdateOnlyHTMLDocument extends HTMLDocument { //UGLY UGLY, HACK, HACK
    private final Map<String, FieldFunction> updateFields;

    public UpdateOnlyHTMLDocument(
        final Map<String, FieldFunction> document,
        final Prefix prefix,
        final long phantomQueueId,
        final String queueName,
        final boolean orderIndependentUpdate,
        final DatabaseConfig config,
        final Logger logger)
        throws ParseException
    {
        super(prefix, phantomQueueId, queueName, orderIndependentUpdate, config, logger);
        primaryKey = extractPrimaryKey(document);
        updateFields = document;
    }

    public Map<String, FieldFunction> updateFields() {
        return updateFields;
    }

    public void upgrade(final ConditionsAccessor condAccessor)
        throws FieldFunctionException
    {
        updateWith(updateFields, this, condAccessor);
        setAuxFields();
    }
}
