package ru.yandex.msearch;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.server.sync.BaseHttpServer;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.uri.CgiParams;

public class UpdateSchemaHandler implements HttpRequestHandler {
    private final DatabaseManager dbManager;
    private final String password;

    public UpdateSchemaHandler(
        final DatabaseManager dbManager)
    {
        this.dbManager = dbManager;
        this.password = dbManager.daemonConfig().dropPassword();
    }

    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        PrefixedLogger logger =
            (PrefixedLogger) context.getAttribute(BaseHttpServer.LOGGER);

        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("No schema in body");
        }

        try {
            CgiParams params = new CgiParams(request);
            Index index = dbManager.index(params);
            boolean force = params.getBoolean("force", false);
            String name = params.getString("schema-name", "default");
            if (name.isEmpty()) {
                name = "default";
            }
            String schemaStr = CharsetUtils.toString(((HttpEntityEnclosingRequest) request).getEntity());
            IniConfig iniConfig = new IniConfig(new StringReader(schemaStr));
//            if (!index.config().fieldsConfig().dynamicFieldsFiles().containsKey(name)) {
//                throw new BadRequestException("No such dynamic schema name " + name);
//            }
            logger.info("Read new schema " + iniConfig.keys().size() + " schema " + schemaStr);
            index.reloadFields(name, force, schemaStr);
        } catch (IOException ioe) {
            response.setStatusCode(HttpStatus.SC_INTERNAL_SERVER_ERROR);
            response.setEntity(new StringEntity(
                "Failed update schema " + ioe.getMessage(),
                StandardCharsets.UTF_8));
            logger.log(Level.WARNING, "Failed update schema", ioe);
            return;
        } catch (Throwable t) {
            HttpIndexerServer.handleException(t, response);
            return;
        }

        response.setStatusCode(HttpStatus.SC_OK);
    }

    @Override
    public String toString() {
        return "Updating dynamic part of config";
    }
}
