package ru.yandex.msearch.collector;

import org.apache.lucene.document.FieldMapping;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.FieldVisitor;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;

public abstract class AbstractFieldVisitor implements FieldVisitor {
    private final FieldToIndex fieldToIndex;
    private FieldInfos fieldInfos = null;
    private FieldMapping fieldMapping = null;

    public AbstractFieldVisitor(final FieldToIndex fieldToIndex) {
        this.fieldToIndex = fieldToIndex;
    }

    @Override
    public FieldMapping fieldMapping(final FieldInfos fieldInfos) {
        if (fieldInfos != this.fieldInfos) {
            int maxFieldCount = 0;
            int numFields = fieldInfos.size();
            FieldSelectorResult[] fieldSelectorResults =
                new FieldSelectorResult[numFields];
            int[] fieldNumberToIndex = new int[numFields];
            for (int i = 0; i < numFields; ++i) {
                FieldInfo fieldInfo = fieldInfos.fieldInfo(i);
                String name = fieldInfo.name;
                FieldSelectorResult fieldSelectorResult =
                    fieldSelectorResult(name);
                fieldSelectorResults[i] = fieldSelectorResult;
                if (fieldSelectorResult != FieldSelectorResult.NO_LOAD) {
                    ++maxFieldCount;
                    fieldNumberToIndex[i] = fieldToIndex.indexFor(name);
                }
            }
            fieldMapping = new FieldMapping(
                fieldSelectorResults,
                fieldNumberToIndex,
                maxFieldCount);
            this.fieldInfos = fieldInfos;
        }
        return fieldMapping;
    }
}

