package ru.yandex.msearch.collector;

import java.io.IOException;

import java.util.Arrays;
import java.util.List;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReader.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public abstract class BaseCollector extends FlushableCollector {
    private static final int[] EMPTY_DOCS = new int[0];
    private static final int MIN_SIZE = 16;

    private int[] docs = EMPTY_DOCS;
    private int docsCount = 0;
    private IndexReader reader = null;
    private int base;

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    @Override
    public void setScorer(final Scorer scorer) {
    }

    @Override
    public void collect(final int doc) throws IOException {
        checkAbort();
        if (docsCount == docs.length) {
            docs = Arrays.copyOf(docs, Math.max(MIN_SIZE, docs.length << 1));
        }
        docs[docsCount++] = doc;
    }

    private void collectDocs() throws IOException {
        Arrays.sort(docs, 0, docsCount);
        for (int i = 0; i < docsCount; ++i) {
            processDoc(reader, base, docs[i]);
        }
        docsCount = 0;
    }

    abstract protected void processDoc(final IndexReader reader, final int base, final int doc)
        throws IOException;

    protected void checkAbort() throws IOException {
    }

    @Override
    public void setNextReader(final AtomicReaderContext readerContext)
        throws IOException
    {
        collectDocs();
        reader = readerContext.reader;
        base = readerContext.docBase;
    }

    @Override
    public void flush() throws IOException {
        collectDocs();
    }

    @Override
    public void close() {
    }
}
