package ru.yandex.msearch.collector;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class CollectingFieldToIndex
    extends IdentityHashMap<String, Integer>
    implements FieldToIndex
{
    private static final long serialVersionUID = 0L;

    public FieldToIndex compactFieldToIndex() {
        switch (size()) {
            case 1:
                return new SingleFieldToIndex(keySet().iterator().next());
            case 2:
                return prepareDoubleFieldToIndex();
            case 3:
                return prepareTripleFieldToIndex();
            default:
                return new MapFieldToIndex(this);
        }
    }

    private DoubleFieldToIndex prepareDoubleFieldToIndex() {
        List<Map.Entry<String, Integer>> list = new ArrayList<>(entrySet());
        list.sort((x, y) -> x.getValue().compareTo(y.getValue()));
        return new DoubleFieldToIndex(
            list.get(0).getKey(),
            list.get(1).getKey());
    }

    private TripleFieldToIndex prepareTripleFieldToIndex() {
        List<Map.Entry<String, Integer>> list = new ArrayList<>(entrySet());
        list.sort((x, y) -> x.getValue().compareTo(y.getValue()));
        return new TripleFieldToIndex(
            list.get(0).getKey(),
            list.get(1).getKey(),
            list.get(2).getKey());
    }

    @Override
    public int indexFor(final String field) {
        Integer index = get(field);
        if (index == null) {
            index = size();
            put(field, index);
        }
        return index;
    }

    @Override
    public int fieldsCount() {
        throw new UnsupportedOperationException(
            "CollectingFieldToIndex is not intended to be used anywhere except"
            + " field collecting");
    }
}

