package ru.yandex.msearch.collector;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.SearchRequest;
import ru.yandex.msearch.SearchResultsConsumer;
import ru.yandex.msearch.collector.sort.NullSortFunc;
import ru.yandex.msearch.collector.sort.SimpleSortFunc;

public abstract class CollectorFactory {
    public abstract String checkRequestParams(final SearchRequest request);
    public abstract DocCollector createCollector(
        final SearchRequest request,
        final SearchResultsConsumer consumer);

    public static CollectorFactory factoryFromRequest(
        final SearchRequest request)
        throws BadRequestException
    {
        if (request.forcedCollectorName() != null) {
            return factoryFromName(request.forcedCollectorName());
        }

        if (PassThruCollector.checkRequestParams(request) == null) {
            return new PassThruCollectorFactory();
        }
        if (request.config().autoPruning()
            && !request.scoring()
            && PruningCollector.checkRequestParams(request) == null)
        {
            return new PruningCollectorFactory();
        }
        return new SortedCollectorFactory();
    }

    public static CollectorFactory factoryFromName(final String name)
        throws BadRequestException
    {
        if (name.startsWith("pruning")) {
            return new PruningCollectorFactory();
        }
        if (name.equals("sorted")) {
            return new SortedCollectorFactory();
        }
        if (name.startsWith("passthru") || name.startsWith("passthrough")) {
            return new PassThruCollectorFactory(name);
        }
        throw new BadRequestException("Unknown collector name: " + name);
    }
}
