package ru.yandex.msearch.collector;

public class DescendingYaField extends FilterYaField {
    public DescendingYaField(final YaField field) {
        super(field);
    }

    @Override
    public FieldType type() {
        return FieldType.DESCENDING;
    }

    @Override
    public int compareTo(final YaField other) {
        FieldType type = type();
        FieldType otherType = other.type();
        if (type == otherType) {
            return YaDoc3.COMPARATOR.compare(
                ((DescendingYaField) other).field,
                field);
        } else {
            return otherType.compareTo(type);
        }
    }

    @Override
    public int doCompareTo(final YaField other) {
        throw new UnsupportedOperationException();
    }
}


