package ru.yandex.msearch.collector;

import java.util.NoSuchElementException;

import org.apache.lucene.util.StringHelper;

public class DoubleFieldToIndex implements FieldToIndex {
    private final String first;
    private final String second;

    public DoubleFieldToIndex(final String first, final String second) {
        this.first = StringHelper.intern(first);
        this.second = StringHelper.intern(second);
    }

    @Override
    public int indexFor(final String field) {
        if (first == field) {
            return 0;
        } else if (second == field) {
            return 1;
        } else {
            throw new NoSuchElementException(field);
        }
    }

    @Override
    public int fieldsCount() {
        return 2;
    }
}

