package ru.yandex.msearch.collector;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.json.writer.Utf8JsonValue;
import ru.yandex.json.writer.Utf8JsonWriter;

public abstract class FilterYaField implements YaField {
    protected final YaField field;

    public FilterYaField(final YaField field) {
        this.field = field;
    }

    @Override
    public long sizeInBytes() {
        return field.sizeInBytes();
    }

    @Override
    public long longValue() {
        return field.longValue();
    }

    @Override
    public int doCompareTo(final YaField other) {
        return field.compareTo(((FilterYaField) other).field);
    }

    @Override
    public String toString() {
        return field.toString();
    }

    @Override
    public int hashCode() {
        return field.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof FilterYaField) {
            FilterYaField other = (FilterYaField) o;
            return type() == other.type() && field.equals(other.field);
        }
        return false;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        field.writeValue(writer);
    }

    @Override
    public void writeValue(final Utf8JsonWriter writer) throws IOException {
        field.writeValue(writer);
    }
}

