package ru.yandex.msearch.collector;

import java.io.IOException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReader.AtomicReaderContext;

public class MapCollector extends BaseCollector {
    private final Map<Integer, Map<String, String>> documents =
        new HashMap<>();
    private final Set<String> fields;
    private final FieldSelector selector;

    public MapCollector(final Set<String> fields) {
        this(fields, new MapFieldSelector(new ArrayList<String>(fields)));
    }

    public MapCollector(final Set<String> fields,
        final FieldSelector selector)
    {
        this.fields = fields;
        this.selector = selector;
    }

    @Override
    protected void processDoc(final IndexReader reader, final int base, final int doc)
        throws IOException
    {
        Map<String, String> result = new HashMap<>();
        Document document = reader.document(doc, selector);
        for (String field: fields) {
            String value = document.get(field);
            if (value == null) {
                throw new CorruptIndexException("Required field not found: "
                    + field);
            }
            result.put(field, value);
        }
        documents.put(base + doc, result);
    }

    public Map<Integer, Map<String, String>> documents() throws IOException {
        flush();
        return Collections.unmodifiableMap(documents);
    }
}

