package ru.yandex.msearch.collector;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

public class MapFieldToIndex implements FieldToIndex {
    private final Map<String, Integer> map;

    public MapFieldToIndex(final Set<String> fields) {
        map = new IdentityHashMap<>(fields.size());
        int i = 0;
        for (String field: fields) {
            map.put(StringHelper.intern(field), i++);
        }
    }

    public MapFieldToIndex(final Map<String, Integer> map) {
        this.map = map;
    }

    @Override
    public int indexFor(final String field) {
        //Cathing NPE here? You forgot to intern field string!
        //Uncomment this code to find a field
        /*
        final Integer index = map.get(field);
        if (index == null) {
            throw new RuntimeException("Unknown field: " + field);
        }
        */
        return map.get(field);
    }

    @Override
    public int fieldsCount() {
        return map.size();
    }
}

