package ru.yandex.msearch.collector;

/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.json.writer.Utf8JsonWriter;

public abstract class MergeFunc {

    public abstract void merge(final YaDoc3 otherDoc);

    public abstract Collection<YaDoc3> merged();

    public abstract void formJson(
        final JsonWriterBase jw,
        final Set<String> getFields,
        final boolean skipNulls)
        throws IOException;

    public abstract void formJson(
        final Utf8JsonWriter jw,
        final Set<String> getFields,
        final boolean skipNulls)
        throws IOException;

    public abstract MergeFunc clone();

    @Override
    public abstract String toString();
}
