package ru.yandex.msearch.collector;

import java.io.IOException;

import java.util.Arrays;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.json.writer.Utf8JsonValue;
import ru.yandex.json.writer.Utf8JsonWriter;

public class MultiYaField implements YaField {
    private final YaField[] fields;
    private int hashCode = 0;
    private int size = 0;

    public MultiYaField(final YaField[] fields) {
        this.fields = fields;
    }

    @Override
    public FieldType type() {
        return FieldType.MULTI;
    }

    @Override
    public long sizeInBytes() {
        int size = this.size;
        if (size == 0) {
            size = 12;
            for (YaField field: fields) {
                size += field.sizeInBytes();
            }
            this.size = size;
        }
        return size;
    }

    @Override
    public long longValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int doCompareTo(final YaField o) {
        YaField[] fields = ((MultiYaField) o).fields;
        int cmp = Integer.compare(this.fields.length, fields.length);
        for (int i = 0; i < fields.length && cmp == 0; ++i) {
            cmp = YaDoc3.COMPARATOR.compare(this.fields[i], fields[i]);
        }
        return cmp;
    }

    @Override
    public String toString() {
        return Arrays.toString(fields);
    }

    @Override
    public int hashCode() {
        if (hashCode == 0) {
            hashCode = Arrays.hashCode(fields);
        }
        return hashCode;
    }

    @Override
    public boolean equals(final Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o instanceof MultiYaField) {
            MultiYaField other = (MultiYaField) o;
            if (hashCode != 0 && other.hashCode != 0
                && hashCode != other.hashCode)
            {
                result = false;
            } else {
                result = Arrays.equals(fields, other.fields);
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startArray();
        for (YaField field: fields) {
            writer.value(field);
        }
        writer.endArray();
    }

    @Override
    public void writeValue(final Utf8JsonWriter writer) throws IOException {
        writer.startArray();
        for (YaField field: fields) {
            writer.value((Utf8JsonValue) field);
        }
        writer.endArray();
    }
}

