package ru.yandex.msearch.collector;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.SearchRequest;
import ru.yandex.msearch.SearchResultsConsumer;

public class PassThruCollectorFactory extends CollectorFactory {
    private int delayCount;

    public PassThruCollectorFactory(final String name)
        throws BadRequestException
    {
        int idx1, idx2;
        idx1 = name.indexOf('(');
        idx2 = name.indexOf(')');
        delayCount = PassThruCollector.DELAYED_OUTPUT_DOC_COUNT;
        if (idx1 != -1 && idx2 != -1) {
            try {
                delayCount = Integer.parseInt(name.substring(idx1 + 1, idx2));
            } catch (NumberFormatException e) {
                throw new BadRequestException(
                    "Invalid collector name format", e);
            }
        }
    }

    public PassThruCollectorFactory() {
        delayCount = PassThruCollector.DELAYED_OUTPUT_DOC_COUNT;
    }

    @Override
    public String checkRequestParams(final SearchRequest request) {
        return PassThruCollector.checkRequestParams(request);
    }

    @Override
    public DocCollector createCollector(
        final SearchRequest request,
        final SearchResultsConsumer consumer)
    {
        return new PassThruCollector(
            request,
            consumer,
            Math.min(delayCount, request.length()));
    }
}

