package ru.yandex.msearch.collector;

import java.io.IOException;

import java.text.ParseException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReader.AtomicReaderContext;

public class PlainCollector extends BaseCollector {
    private final int maxDocs;
    private final ArrayList<Document> docs;

    public PlainCollector(final int maxDocs)
    {
        this.maxDocs = maxDocs;
        this.docs = new ArrayList<Document>(maxDocs);
    }

    @Override
    protected void processDoc(final IndexReader reader, final int base,
        final int doc)
        throws IOException
    {
        if (docs.size() < maxDocs) {
            docs.add(reader.document(doc));
        }
    }

    public List<Document> docs() {
        return docs;
    }
}

