package ru.yandex.msearch.collector;

import java.util.NoSuchElementException;

import org.apache.lucene.util.StringHelper;

public class SingleFieldToIndex implements FieldToIndex {
    private final String field;

    public SingleFieldToIndex(final String field) {
        this.field = StringHelper.intern(field);
    }

    @Override
    public int indexFor(final String field) {
        if (this.field == field) {
            return 0;
        } else {
            throw new NoSuchElementException(field);
        }
    }

    @Override
    public int fieldsCount() {
        return 1;
    }
}

