package ru.yandex.msearch.collector;

import java.util.NoSuchElementException;

import org.apache.lucene.util.StringHelper;

public class TripleFieldToIndex implements FieldToIndex {
    private final String first;
    private final String second;
    private final String third;

    public TripleFieldToIndex(
        final String first,
        final String second,
        final String third)
    {
        this.first = StringHelper.intern(first);
        this.second = StringHelper.intern(second);
        this.third = StringHelper.intern(third);
    }

    @Override
    public int indexFor(final String field) {
        if (first == field) {
            return 0;
        } else if (second == field) {
            return 1;
        } else if (third == field) {
            return 2;
        } else {
            throw new NoSuchElementException(field);
        }
    }

    @Override
    public int fieldsCount() {
        return 3;
    }
}

