package ru.yandex.msearch.collector;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;

import ru.yandex.msearch.FieldFunctionIOException;
import ru.yandex.msearch.HTMLDocument;
import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.search.json.fieldfunction.ConditionsAccessor;
import ru.yandex.search.json.fieldfunction.FieldFunction;
import ru.yandex.search.json.fieldfunction.FieldFunctionException;
import ru.yandex.search.prefix.Prefix;

public class UpdatingCollector extends BaseUpdatingCollector {
    protected final List<HTMLDocument> documents = new ArrayList<>();
    protected final Map<String, FieldFunction> fields;
    protected final Prefix prefix;
    protected final long phantomQueueId;
    protected final String queueName;
    protected final ConditionsAccessor condAccessor;
    protected boolean orderIndependentUpdate;
    protected final DatabaseConfig config;
    protected final Logger logger;

    public UpdatingCollector(
        final Map<String, FieldFunction> fields,
        final Prefix prefix,
        final long phantomQueueId,
        final String queueName,
        final ConditionsAccessor condAccessor,
        final boolean orderIndependentUpdate,
        final DatabaseConfig config,
        final Logger logger)
    {
        this.fields = fields;
        this.prefix = prefix;
        this.phantomQueueId = phantomQueueId;
        this.queueName = queueName;
        this.condAccessor = condAccessor;
        this.config = config;
        this.logger = logger;
        this.orderIndependentUpdate = orderIndependentUpdate;
    }

    @Override
    protected void processDoc(
        final IndexReader reader,
        final int base,
        final int doc)
        throws IOException
    {
        try {
            HTMLDocument document =
                new HTMLDocument(
                    reader.document(doc),
                    prefix,
                    phantomQueueId,
                    queueName,
                    orderIndependentUpdate,
                    config,
                    logger);
            document.updateWith(fields, condAccessor);
            documents.add(document);
        } catch (ParseException e) {
            throw new CorruptIndexException(e.getMessage());
        } catch (FieldFunctionException e) {
            throw new FieldFunctionIOException(e);
        }
    }

    public List<HTMLDocument> documents() throws IOException {
        flush();
        return Collections.unmodifiableList(documents);
    }
}
