package ru.yandex.msearch.collector;

import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.util.BytesRef;

import ru.yandex.msearch.FieldConfig;

public final class YaDocFieldVisitor extends AbstractFieldVisitor {
    private final FieldSelector fieldSelector;
    private final FieldConfig[] configs;
    private YaDoc3 doc;

    public YaDocFieldVisitor(
        final FieldSelector fieldSelector,
        final FieldToIndex fieldToIndex,
        final FieldConfig[] configs)
    {
        super(fieldToIndex);
        this.fieldSelector = fieldSelector;
        this.configs = configs;
    }

    public void doc(final YaDoc3 doc) {
        this.doc = doc;
    }

    @Override
    public FieldSelectorResult fieldSelectorResult(final String fieldName) {
        return fieldSelector.accept(fieldName);
    }

    @Override
    public void storeFieldValue(final int index, final byte[] value) {
        doc.setField(index, configs[index].type().create(value));
    }

    @Override
    public void storeFieldSize(final int index, final int size) {
        doc.setField(index, new YaField.SizeOnlyYaField(size << 1));
    }
}

