package ru.yandex.msearch.collector.aggregate;

import java.text.ParseException;

import java.util.Locale;

import ru.yandex.function.GenericBiFunction;

import ru.yandex.msearch.collector.FieldToIndex;

public enum AggregateFuncFactory
    implements GenericBiFunction<
        String,
        FieldToIndex,
        AggregateFunc,
        ParseException>
{
    INSTANCE;

    @Override
    public AggregateFunc apply(
        final String str,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        String outFieldName = str;
        String funcParams = str;
        int lastWhiteSpace = str.lastIndexOf(' ');
        if (lastWhiteSpace != -1) {
            outFieldName = str.substring(lastWhiteSpace + 1);
            funcParams = str.substring(0, lastWhiteSpace);
        }

        int startBrace = funcParams.indexOf('(');
        if (startBrace == -1) {
            throw new ParseException(
                "AggregateFuncFactory parse error: function <" + str
                + "> doesn't have arguments start brace (",
                0);
        }
        int endBrace = funcParams.lastIndexOf(')');
        if (endBrace == -1) {
            throw new ParseException(
                "AggregateFuncFactory parse error: function <" + str
                + "> doesn't have arguments end brace )",
                0);
        }
        String funcName =
            funcParams.substring(0, startBrace).toLowerCase(Locale.ROOT);
        String args = funcParams.substring(startBrace + 1, endBrace);

        switch (funcName) {
            case "avg":
                return new AvgFunc(outFieldName, args, fieldToIndex);
            case "sum":
                return new SumFunc(outFieldName, args, fieldToIndex);
            case "set":
                return new LimitedSetAggFunc(outFieldName, args, fieldToIndex);
            case "count":
                return new CountFunc(outFieldName, args, fieldToIndex);
            default:
                throw new ParseException(
                    "AggregateFuncFactory parse error: unknown function name <"
                    + funcName + "> int string < " + str + ">",
                    0);
        }
    }
}

