package ru.yandex.msearch.collector.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.msearch.collector.FieldsProducingFunction;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class Aggregator implements FieldsProducingFunction {
    private final List<AggregateFunc> functions;

    public Aggregator(final List<AggregateFunc> functions) {
        this.functions = functions;
    }

    public void updateValues(final YaDoc3 doc) {
        for (AggregateFunc func: functions) {
            func.updateValue(doc);
        }
    }

    public void pushFields(final YaDoc3 doc) {
        for (AggregateFunc func: functions) {
            doc.setField(func.outFieldIndex(), func.aggField());
        }
    }

    @Override
    public Set<String> outFields() {
        Set<String> outFields = new LinkedHashSet<>(functions.size() << 1);
        for (AggregateFunc func: functions) {
            outFields.add(func.outFieldName());
        }
        return outFields;
    }

    public Aggregator clone() {
        List<AggregateFunc> functions = new ArrayList<>(this.functions.size());
        for (AggregateFunc func: this.functions) {
            functions.add(func.clone());
        }
        return new Aggregator(functions);
    }

    @Override
    public Set<String> loadFields() {
        Set<String> loadFields = new HashSet<>(functions.size() << 1);
        for (AggregateFunc func: functions) {
            loadFields.addAll(func.loadFields());
        }
        return loadFields;
    }

    @Override
    public String toString() {
        return "Aggregator" + functions.toString();
    }
}

