package ru.yandex.msearch.collector.aggregate;

import java.util.ArrayList;

import ru.yandex.function.GenericBiFunction;

import ru.yandex.msearch.collector.FieldToIndex;

import ru.yandex.parser.string.CollectionParser;

public enum AggregatorFactory
    implements GenericBiFunction<
        String,
        FieldToIndex,
        Aggregator,
        Exception>
{
    INSTANCE;

    @Override
    public Aggregator apply(
        final String str,
        final FieldToIndex fieldToIndex)
        throws Exception
    {
        return new Aggregator(
            new CollectionParser<>(
                x -> AggregateFuncFactory.INSTANCE.apply(x, fieldToIndex),
                ArrayList::new)
                .apply(str));
    }
}

