package ru.yandex.msearch.collector.aggregate;

import java.util.Collections;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class AvgFunc implements AggregateFunc {
    private final String outFieldName;
    private final String fieldName;
    private final int outFieldIndex;
    private final int fieldIndex;
    private final YaField.LongYaField valueField;
    private long sum = 0;
    private int count = 0;

    public AvgFunc(
        final String outFieldName,
        final String fieldName,
        final FieldToIndex fieldToIndex)
    {
        this.outFieldName = StringHelper.intern(outFieldName);
        this.fieldName = StringHelper.intern(fieldName);
        outFieldIndex = fieldToIndex.indexFor(this.outFieldName);
        fieldIndex = fieldToIndex.indexFor(this.fieldName);
        // Original aggregate func should not be modified
        valueField = null;
    }

    private AvgFunc(final AvgFunc sample) {
        outFieldName = sample.outFieldName;
        fieldName = sample.fieldName;
        outFieldIndex = sample.outFieldIndex;
        fieldIndex = sample.fieldIndex;
        valueField = new YaField.LongYaField(0L);
    }

    @Override
    public AggregateFunc clone() {
        return new AvgFunc(this);
    }

    @Override
    public String outFieldName() {
        return outFieldName;
    }

    @Override
    public int outFieldIndex() {
        return outFieldIndex;
    }

    @Override
    public YaField aggField() {
        return valueField;
    }

    @Override
    public void updateValue(final YaDoc3 doc) {
        YaField docField = doc.getField(fieldIndex);
        if (docField != null) {
            sum += docField.longValue();
            count++;
            valueField.setValue(sum / count);
        }
    }

    @Override
    public Set<String> loadFields() {
        return Collections.singleton(fieldName);
    }

    @Override
    public String toString() {
        return "AVG(" + fieldName + ')';
    }
}

