package ru.yandex.msearch.collector.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.msearch.ClusteringConfig;

public class Cluster extends AbstractCluster<Cluster> {
    private ClusterDoc[] docs;

    public Cluster(
        final ClusteringConfig config,
        final Map<String, Map<String, Counter>> counters,
        final ClusterDoc doc)
    {
        super(config, counters, doc.date());
        docs = new ClusterDoc[] {doc};
    }

    @Override
    protected void addDoc(final ClusterDoc doc) {
        if (size == docs.length) {
            int newSize;
            if (size == 1) {
                newSize = 2;
            } else {
                newSize = size + (size >> 1);
            }
            docs = Arrays.copyOf(docs, newSize);
        }
        docs[size] = doc;
    }

    @Override
    protected void addDocs(final Cluster other) {
        if (size + other.size > docs.length) {
            docs = Arrays.copyOf(docs, size + other.size);
        }
        System.arraycopy(other.docs, 0, docs, size, other.size);
    }

    @Override
    protected List<ClusterDoc> sortedDocs() {
        if (config.asc()) {
            Arrays.sort(docs, 0, size);
        } else {
            Arrays.sort(docs, 0, size, Collections.reverseOrder());
        }
        return Arrays.asList(docs).subList(0, size);
    }

    @Override
    public boolean isClose(
        final ClusterDoc remote,
        final long dateFrom,
        final long dateTo,
        final double distanceThreshold)
    {
        for (int i = size; i-- > 0;) {
            ClusterDoc doc = docs[i];
            long date = doc.date();
            if (date >= dateFrom
                && date <= dateTo
                && doc.hasValidCoords()
                && doc.distanceTo(remote) < distanceThreshold)
            {
                return true;
            }
        }
        return false;
    }
}

