package ru.yandex.msearch.collector.cluster;

import ru.yandex.msearch.collector.YaField;

public class ClusterWithGroup implements Comparable<ClusterWithGroup> {
    private final AbstractCluster<?> cluster;
    private final YaField group;

    public ClusterWithGroup(
        final AbstractCluster<?> cluster,
        final YaField group)
    {
        this.cluster = cluster;
        this.group = group;
    }

    public AbstractCluster<?> cluster() {
        return cluster;
    }

    public YaField group() {
        return group;
    }

    @Override
    public int compareTo(final ClusterWithGroup other) {
        int cmp = Long.compare(cluster.maxDate(), other.cluster.maxDate());
        if (cmp == 0) {
            cmp = group.compareTo(other.group);
        }
        return cmp;
    }
}

