package ru.yandex.msearch.collector.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;

import ru.yandex.msearch.ClusteringConfig;

public class TruncatedCluster extends AbstractCluster<TruncatedCluster> {
    private final int mergedLength;
    private final Queue<ClusterDoc> docs;

    public TruncatedCluster(
        final ClusteringConfig config,
        final Map<String, Map<String, Counter>> counters,
        final ClusterDoc doc)
    {
        super(config, counters, doc.date());
        mergedLength = config.mergedLength();
        // Order is inversed, so we can evict elements by simple polling
        Comparator<ClusterDoc> comparator;
        if (config.asc()) {
            comparator = Collections.reverseOrder();
        } else {
            comparator = null;
        }
        docs = new PriorityQueue<>(mergedLength + 1, comparator);
        docs.add(doc);
    }

    @Override
    protected void addDoc(final ClusterDoc doc) {
        // TODO: Some adds can be skipped by checking min/max date
        // Need to have some stats on this
        docs.add(doc);
        if (docs.size() > mergedLength) {
            docs.poll();
        }
    }

    @Override
    protected void addDocs(final TruncatedCluster other) {
        docs.addAll(other.docs);
        while (docs.size() > mergedLength) {
            docs.poll();
        }
    }

    @Override
    protected List<ClusterDoc> sortedDocs() {
        // TODO: Use heap sort here
        List<ClusterDoc> docs = new ArrayList<>(this.docs);
        if (config.asc()) {
            Collections.sort(docs);
        } else {
            Collections.sort(docs, Collections.reverseOrder());
        }
        return docs;
    }
}

