package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public abstract class BinaryNonNullOperatorDocProcessor
    extends ManyToOneDocProcessor
{
    public BinaryNonNullOperatorDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex, 2, 2);
    }

    protected abstract YaField process(final YaField lhs, final YaField rhs);

    @Override
    public void process(final YaDoc3 doc) {
        YaField lhs = doc.getField(fieldIndexes[0]);
        if (lhs != null) {
            YaField rhs = doc.getField(fieldIndexes[1]);
            if (rhs != null) {
                doc.setField(outFieldIndex, process(lhs, rhs));
            }
        }
    }
}

