package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import java.util.Collections;
import java.util.Set;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

import ru.yandex.util.string.StringUtils;

public class CIDotProductDocProcessor implements DocProcessor {
    private final String outField;
    private final String field;
    private final int outFieldIndex;
    private final int fieldIndex;
    private final int[] value;

    public CIDotProductDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.indexOf(' ');
        int space2 = args.indexOf(' ', space + 1);
        if (space <= 0
            || space2 <= 0
            || space + 1 == space2
            || space2 + 1 == args.length())
        {
            throw new ParseException(
                "CIDotProductDocProcessor args expected to be in form: "
                + "field vector outfield",
                0);
        }
        outField = StringHelper.intern(args.substring(space2 + 1));
        field = StringHelper.intern(args.substring(0, space));
        outFieldIndex = fieldToIndex.indexFor(outField);
        fieldIndex = fieldToIndex.indexFor(field);

        String value = args.substring(space + 1, space2);
        try {
            this.value = YaField.IntArrayYaField.parse(
                StringUtils.getUtf8Bytes(value));
        } catch (Exception e) {
            ParseException ex = new ParseException(
                "Failed to parse floats vector from string: " + value,
                0);
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(field, outField);
    }

    @Override
    public void process(final YaDoc3 doc) {
        YaField field = doc.getField(fieldIndex);
        if (field instanceof YaField.IntArrayYaField) {
            int res = ((YaField.IntArrayYaField) field).minHashDotProduct(value);
            doc.setField(outFieldIndex, new YaField.IntegerYaField(res));
        }
    }
}

