package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import java.util.Collections;
import java.util.Set;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class CLogDocProcessor extends FieldConstDocProcessor {
    private static final LogFunc LOG_E = new LogE();
    private static final LogFunc LOG_10 = new Log10();
    private final LogFunc logFunc;

    public CLogDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
        final float base = value.floatValue();
        if (base == Math.E) {
            logFunc = LOG_E;
        } else if (base == 10) {
            logFunc = LOG_10;
        } else {
            logFunc = new LogB(base);
        }
    }

    @Override
    protected YaField process(final YaField field) {
        final float value = field.floatValue();
        final float result;
        if (value == 0) {
            result = 0;
        } else {
            result = (float) logFunc.compute(value);
        }
        return new YaField.FloatYaField(result);
    }

    private interface LogFunc {
        double compute(float value);
    }

    private static final class LogE implements LogFunc {
        @Override
        public double compute(final float value) {
            return Math.log(value);
        }
    }

    private static final class Log10 implements LogFunc {
        @Override
        public double compute(final float value) {
            return Math.log10(value);
        }
    }

    private static final class LogB implements LogFunc {
        private final double baseLog;

        public LogB(final float base) {
            this.baseLog = Math.log(base);
        }

        @Override
        public double compute(final float value) {
            return Math.log(value) / baseLog;
        }
    }
}

