package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import org.apache.lucene.util.BytesRef;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

import ru.yandex.util.string.StringUtils;

public class ConcatDocProcessor extends ManyToOneDocProcessor {
    public ConcatDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    public void process(final YaDoc3 doc) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldIndexes.length; ++i) {
            YaField field = doc.getField(fieldIndexes[i]);
            if (field == null) {
                return;
            }
            sb.append(field.toString());
        }
        doc.setField(
            outFieldIndex,
            new YaField.StringYaField(
                StringUtils.getUtf8Bytes(new String(sb))));
    }
}

