package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import java.util.Collections;
import java.util.Set;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

import ru.yandex.util.string.StringUtils;

public class ConstDocProcessor implements DocProcessor {
    private final YaField.StringYaField field;
    private final String outField;
    private final int outFieldIndex;

    public ConstDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.indexOf(' ');
        if (space < 0 || space + 1 == args.length()) {
            throw new ParseException(
                "ConstDocProcessor args expected to be in form: "
                + "value outfield",
                0);
        }
        field = new YaField.StringYaField(
            StringUtils.getUtf8Bytes(args.substring(0, space)));
        outField = StringHelper.intern(args.substring(space + 1));
        outFieldIndex = fieldToIndex.indexFor(outField);
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.addWithSingleOut(outField);
    }

    @Override
    public void process(final YaDoc3 doc) {
        doc.setField(outFieldIndex, field);
    }
}

