package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import java.util.ArrayList;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class ContainsDocProcessor implements DocProcessor {
    private final String field;
    private final String outField;
    protected final String[] needles;
    protected final int fieldIndex;
    protected final int outFieldIndex;
    protected final boolean any;

    public ContainsDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        this(args, fieldToIndex, false);
    }

    public ContainsDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex,
        final boolean any)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.lastIndexOf(' ');
        if (space <= 0 || space + 1 == args.length()) {
            throw new ParseException(
                "No outfield specified. "
                + "Arguments expected to be in form: "
                + "field1,needle1(,needle2)* outfield. Was: "
                + args,
                0);
        }
        int comma = args.indexOf(',');
        if (comma == -1 || comma > space) {
            throw new ParseException(
                "Empty or missing needles to search for. "
                + "Arguments expected to be in form: "
                + "field1,needle1(,needle2)* outfield. Was: "
                + args,
                0);
        }
        field = StringHelper.intern(args.substring(0, comma));
        outField = StringHelper.intern(args.substring(space + 1));
        fieldIndex = fieldToIndex.indexFor(field);
        outFieldIndex = fieldToIndex.indexFor(outField);
        final ArrayList<String> needles = new ArrayList<>();
        final StringBuilder sb = new StringBuilder();
        boolean forceNext = false;
        for (int i = comma + 1; i < space; i++) {
            final char c = args.charAt(i);
            if (forceNext) {
                sb.append(c);
                forceNext = false;
            } else if (c == ',') {
                needles.add(StringHelper.intern(new String(sb)));
                sb.setLength(0);
            } else if (c == '\\') {
                forceNext = true;
            } else {
                sb.append(c);
            }
        }
        if (sb.length() == 0) {
            throw new ParseException(
                "Unterminated needle expression: "
                + "unexpected ' ' after ','",
                0);
        }
        needles.add(StringHelper.intern(new String(sb)));
        this.needles = needles.toArray(new String[0]);
        this.any = any;
    }

    @Override
    public void process(final YaDoc3 doc) {
        final YaField field = doc.getField(fieldIndex);
        int found = 0;
        if (field != null) {
            final String value = field.toString();
            for (final String needle : needles) {
                if (value.contains(needle)) {
                    found++;
                    if (any) {
                        break;
                    }
                }
            }
        }
        doc.setField(outFieldIndex, new YaField.IntegerYaField(found));
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(field, outField);
    }
}

