package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.ProcessorRequestContext;
import ru.yandex.parser.string.EnumParser;

public class DefaultDocProcessorFactory implements DocProcessorFactory {
    public DefaultDocProcessorFactory() {
    }

    @Override
    public DocProcessor apply(
        final String value,
        final ProcessorRequestContext context)
        throws ParseException
    {
        int idx = value.indexOf('(');
        String name;
        String args;
        if (idx == -1) {
            name = value;
            args = null;
        } else {
            int lastPos = value.length() - 1;
            if (value.charAt(lastPos) != ')') {
                throw new ParseException(
                    "DocProcessor expected to be in form: name(args)", 0);
            }
            name = value.substring(0, idx);
            args = value.substring(idx + 1, lastPos);
        }
        try {
            return new EnumParser<>(DefaultDocProcessorType.class)
                .apply(name)
                .create(args, context);
        } catch (RuntimeException e) {
            ParseException ex = new ParseException(
                "Failed to parse function: " + value,
                0);
            ex.initCause(e);
            throw ex;
        }
    }
}
