package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.ProcessorRequestContext;
import ru.yandex.msearch.collector.FieldToIndex;

public enum DefaultDocProcessorType implements DocProcessorType {
    FALLBACK {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new FallbackDocProcessor(args, fieldToIndex);
        }
    },
    EXTRACTDATE {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ExtractDateDocProcessor(args, fieldToIndex);
        }
    },
    EXTRACT_DATE {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ExtractDateDocProcessor(args, fieldToIndex);
        }
    },
    K_DAYS_OLD {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new KDaysOldDocProcessor(args, fieldToIndex);
        }
    },
    CONTAINS {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ContainsDocProcessor(args, fieldToIndex);
        }
    },
    CONTAINS_ANY {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ContainsAnyDocProcessor(args, fieldToIndex);
        }
    },
    MAP_CONTAINS {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new MapContainsDocProcessor(args, fieldToIndex);
        }
    },
    MAP_CONTAINS_ANY {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new MapContainsAnyDocProcessor(args, fieldToIndex);
        }
    },
    MAP_GET {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new MapExtractValueProcessor(args, fieldToIndex);
        }
    },
    REGEX_CONTAINS {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new RegexContainsDocProcessor(args, fieldToIndex);
        }
    },
    REGEX_CONTAINS_ANY {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new RegexContainsAnyDocProcessor(args, fieldToIndex);
        }
    },
    POLY {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new PolyDocProcessor(args, fieldToIndex);
        }
    },
    INCREMENT {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new IncrementFieldDocProcessor(args, fieldToIndex);
        }
    },
    CDIV {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new CDivDocProcessor(args, fieldToIndex);
        }
    },
    CFDIV {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new CFDivDocProcessor(args, fieldToIndex);
        }
    },
    CMUL {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new CMulDocProcessor(args, fieldToIndex);
        }
    },
    MUL {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new MulDocProcessor(args, fieldToIndex);
        }
    },
    FMUL {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new FMulDocProcessor(args, fieldToIndex);
        }
    },
    DIV {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new DivDocProcessor(args, fieldToIndex);
        }
    },
    FDIV {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new FDivDocProcessor(args, fieldToIndex);
        }
    },
    CLOG {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new CLogDocProcessor(args, fieldToIndex);
        }
    },
    SUB {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new SubDocProcessor(args, fieldToIndex);
        }
    },
    SUM {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new SumDocProcessor(args, fieldToIndex);
        }
    },
    CSUB {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new CSubDocProcessor(args, fieldToIndex);
        }
    },
    CSUM {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new CSumDocProcessor(args, fieldToIndex);
        }
    },
    CONCAT {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ConcatDocProcessor(args, fieldToIndex);
        }
    },
    CONST {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ConstDocProcessor(args, fieldToIndex);
        }
    },
    MIN {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new MinFieldDocProcessor(args, fieldToIndex);
        }
    },
    ROUND {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new RoundDocProcessor(args, fieldToIndex);
        }
    },
    TO_LONG {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ToLongDocProcessor(args, fieldToIndex);
        }
    },
    TO_STRING {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ToStringDocProcessor(args, fieldToIndex);
        }
    },
    DESCENDING {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new DescendingFieldDocProcessor(args, fieldToIndex);
        }
    },
    MULTI {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new MultiFieldDocProcessor(args, fieldToIndex);
        }
    },
    CDOT_PRODUCT {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new CDotProductDocProcessor(args, fieldToIndex);
        }
    },
    CHEX_DOT_PRODUCT {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new CHexDotProductDocProcessor(args, fieldToIndex);
        }
    },
    IF {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new IfDocProcessor(args, fieldToIndex);
        }
    },
    EQUALS {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new EqualsDocProcessor(args, fieldToIndex);
        }
    },
    GEO_DISTANCE {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new GeoDistanceDocProcessor(args, fieldToIndex);
        }
    },
    FCONST {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new FloatConstDocProcessor(args, fieldToIndex);
        }
    },
    LEFT_JOIN {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }

        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new LeftJoinDocProcessor(args, context);
        }
    },
    TREE_ROOT {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }

        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new TreeRootDocProcessor(args, context);
        }
    },
    TREE_ROOT_REV {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }

        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new DiskTreeRootDocProcessor(args, context);
        }
    },
    TREE_CALC {
        @Override
        public DocProcessor create(
            final String args, final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }

        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new TreeCalcDocProcessor(args, context);
        }
    },
    FILTER_CMP {
        @Override
        public DocProcessor create(
            final String args, final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }

        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new FilterCompareDocProcessor(args, context);
        }
    },
    FILTER_BY_CONTACTS {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }

        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new FilterByContactsDocProcessor(args, context);
        }
    },
    REPLACE_ALL {
        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            return new ReplaceAllDocProcessor(args, fieldToIndex);
        }
    };
}
