package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class DivDocProcessor extends BinaryNonNullOperatorDocProcessor {
    public DivDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    protected YaField process(final YaField lhs, final YaField rhs) {
        final long divisor = rhs.longValue();
        final long result;
        if (divisor == 0) {
            result = 0;
        } else {
            result = lhs.longValue() / divisor;
        }
        return new YaField.LongYaField(result);
    }
}

