package ru.yandex.msearch.collector.docprocessor;

import java.io.IOException;

import ru.yandex.msearch.collector.YaDoc3;

public interface DocProcessor {
    default void process(YaDoc3 doc) throws IOException {
    }

    void apply(ModuleFieldsAggregator aggregator);

    default void after() {
    }

    default boolean processWithFilter(YaDoc3 doc) throws IOException {
        process(doc);
        return true;
    }
}

