package ru.yandex.msearch.collector.docprocessor;

import com.google.common.base.Objects;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

import java.text.ParseException;

public class EqualsDocProcessor extends ContainsDocProcessor {
    public EqualsDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    public void process(final YaDoc3 doc) {
        final YaField field = doc.getField(fieldIndex);
        boolean equal = false;
        if (field != null) {
            final String value = field.toString();
            for (final String needle: needles) {
                if (Objects.equal(value, needle)) {
                    equal = true;
                    break;
                }
            }
        }
        doc.setField(outFieldIndex, new YaField.IntegerYaField(equal ? 1 : 0));
    }
}