package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class FDivDocProcessor extends BinaryNonNullOperatorDocProcessor {
    public FDivDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    protected YaField process(final YaField lhs, final YaField rhs) {
        final float divisor = rhs.floatValue();
        final float result;
        if (divisor == 0.0) {
            result = 0;
        } else {
            result = lhs.floatValue() / divisor;
        }
        return new YaField.FloatYaField(result);
    }
}
