package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class FallbackDocProcessor extends ManyToOneDocProcessor {
    public FallbackDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    @Override
    public void process(final YaDoc3 doc) {
        for (int fieldIndex: fieldIndexes) {
            YaField field = doc.getField(fieldIndex);
            if (field != null) {
                doc.setField(outFieldIndex, field);
                break;
            }
        }
    }
}

