package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import java.util.Collections;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public abstract class FieldConstDocProcessor implements DocProcessor {
    private final String field;
    private final String outField;
    protected final int fieldIndex;
    protected final int outFieldIndex;
    protected final Number value;

    public FieldConstDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.indexOf(' ');
        int comma = args.indexOf(',');
        String field;
        String outField;
        if (space == -1) {
            if (comma == -1) {
                field = args;
                outField = args;
                value = 1L;
            } else {
                field = args.substring(0,comma);
                outField = field;
                value = parse(args, comma + 1, args.length());
            }
        } else if (comma == -1) {
            field = args.substring(0, space);
            outField = args.substring(space + 1);
            value = 1L;
        } else {
            if (comma > space) {
                throw new ParseException(
                    "Bad comma position in " + args,
                    comma);
            }
            field = args.substring(0, comma);
            outField = args.substring(space + 1);
            value = parse(args, comma + 1, space);
        }
        this.field = StringHelper.intern(field);
        this.outField = StringHelper.intern(outField);
        fieldIndex = fieldToIndex.indexFor(this.field);
        outFieldIndex = fieldToIndex.indexFor(this.outField);
    }

    protected abstract YaField process(final YaField field);

    private static Number parse(final String str, final int start, final int end)
        throws ParseException
    {
        if (end - start == 1
                && (str.charAt(start) == 'E' || str.charAt(start) == 'e'))
        {
            return Math.E;
        }
        final char endChar = str.charAt(end - 1);
        if (endChar == 'f' || endChar == 'F') {
            try {
                return Double.valueOf(str.substring(start, end - 1));
            } catch (RuntimeException e) {
                throw new ParseException("Failed to parse " + str, start);
            }
        } else {
            try {
                return Long.valueOf(str.substring(start, end));
            } catch (RuntimeException e) {
                throw new ParseException("Failed to parse " + str, start);
            }
        }
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(field, outField);
    }

    @Override
    public void process(final YaDoc3 doc) {
        YaField field = doc.getField(fieldIndex);
        if (field != null) {
            doc.setField(outFieldIndex, process(field));
        }
    }
}

