package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class GeoDistanceDocProcessor extends ManyToOneDocProcessor {
    private static final float R = 6371e3f;

    public GeoDistanceDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex, 2 + 2, 2 + 2);
    }

    @Override
    public void process(final YaDoc3 doc) {
        final YaField lat1Field = doc.getField(fieldIndexes[0]);
        final YaField lon1Field = doc.getField(fieldIndexes[1]);
        final YaField lat2Field = doc.getField(fieldIndexes[2]);
        final YaField lon2Field = doc.getField(fieldIndexes[3]);
        final float lat1 = lat1Field.floatValue();
        final float lon1 = lon1Field.floatValue();
        final float lat2 = lat2Field.floatValue();
        final float lon2 = lon2Field.floatValue();
        final float lat1Rad = (float) Math.toRadians(lat1Field.floatValue());
        final float lat2Rad = (float) Math.toRadians(lat2Field.floatValue());
        final float dLonRad = (float) Math.toRadians(
            lon2Field.floatValue() - lon1Field.floatValue());
        final float distance = (float) Math.acos(
            Math.sin(lat1Rad) * Math.sin(lat2Rad)
            + Math.cos(lat1Rad) * Math.cos(lat2Rad)
                * Math.cos(dLonRad)) * R;
        doc.setField(outFieldIndex, new YaField.FloatYaField(distance));
    }
}

