package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class IfDocProcessor extends ManyToOneDocProcessor {
    public IfDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex, 3, 3);
    }

    @Override
    public void process(final YaDoc3 doc) {
        YaField condition = doc.getField(fieldIndexes[0]);
        if (condition != null) {
            if (condition.longValue() != 0) {
                doc.setField(outFieldIndex, doc.getField(fieldIndexes[1]));
            } else {
                doc.setField(outFieldIndex, doc.getField(fieldIndexes[2]));
            }
        }
    }
}