package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import java.util.Collections;
import java.util.Set;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;

public class KDaysOldDocProcessor extends FieldConstDocProcessor {
    private static final float SECS_IN_DAY = 86400;

    private final long currentTime;
    private final float K;

    public KDaysOldDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
        K = SECS_IN_DAY * value.floatValue();
        currentTime = System.currentTimeMillis() / 1000;
    }

    @Override
    protected YaField process(final YaField field) {
        return new YaField.FloatYaField(
            (currentTime - field.longValue()) / K);
    }
}
