package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;

public abstract class ManyToOneDocProcessor implements DocProcessor {
    private final String[] fields;
    private final String outField;
    protected final int[] fieldIndexes;
    protected final int outFieldIndex;

    public ManyToOneDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        this(args, fieldToIndex, -1, -1);
    }

    public ManyToOneDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex,
        final int minInputFieldsCount,
        final int maxInputFieldsCount)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.indexOf(' ');
        if (space <= 0 || space + 1 == args.length()) {
            throw new ParseException(
                "Arguments expected to be in form: field1(,field2)* outfield",
                0);
        }
        String[] fields = args.substring(0, space).split(",");
        this.fields = new String[fields.length];
        fieldIndexes = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String field = StringHelper.intern(fields[i]);
            this.fields[i] = field;
            fieldIndexes[i] = fieldToIndex.indexFor(field);
        }
        outField = StringHelper.intern(args.substring(space + 1));
        outFieldIndex = fieldToIndex.indexFor(outField);
        if (minInputFieldsCount != -1 && fields.length < minInputFieldsCount) {
            throw new ParseException(
                "At least " + minInputFieldsCount
                + " input fields expected: " + args,
                0);
        }
        if (maxInputFieldsCount != -1 && fields.length > maxInputFieldsCount) {
            throw new ParseException(
                "At most " + maxInputFieldsCount
                + " input fields expected: " + args,
                0);
        }
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.addWithSingleOut(outField, fields);
    }
}

