package ru.yandex.msearch.collector.docprocessor;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.search.json.fieldfunction.SumMapFunction;

public class MapContainsDocProcessor extends ContainsDocProcessor {
    public MapContainsDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        super(args, fieldToIndex);
    }

    public MapContainsDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex,
        final boolean any) throws ParseException
    {
        super(args, fieldToIndex, any);
    }

    @Override
    public void process(final YaDoc3 doc) {
        final YaField field = doc.getField(fieldIndex);
        int found = 0;
        if (field != null) {
            final String value = field.toString();
            Map<String, Long> map = new HashMap<>();
            try {
                SumMapFunction.parseMap(map, value);
            } catch (NumberFormatException nfe) {
            }

            for (final String needle : needles) {
                if (map.containsKey(needle)) {
                    found++;
                    if (any) {
                        break;
                    }
                }
            }
        }

        doc.setField(outFieldIndex, new YaField.IntegerYaField(found));
    }
}
